#include "stdafx.h"
#include "CompareImages.h"

CompareImages::FidelityMetrics CompareImages::calcFidelityMetrics(Image8bpp *pImage1, 
																  Image8bpp *pImage2, 
																  int khw /*= 0*/)
{
	if (pImage1->getHeight()!=pImage2->getHeight() ||
		pImage1->getWidth()!=pImage2->getWidth())
		throw std::runtime_error("invalid args: images must be same size!");

	int nr = pImage1->getHeight(),
		nc = pImage1->getWidth(),
		stride = pImage1->getStride();

	// compute mean-squared error here 
	// (remember we only care about the interior portion of the image)

	unsigned long sumsq = 0; // sum of the squares
	Ipp8u *p1, *p2;
	for (int ir=khw; ir<nr-khw; ++ir) {
		p1 = pImage1->getPixels() + ir*stride + khw; // offset into interior
		p2 = pImage2->getPixels() + ir*stride + khw; // offset into interior
		for (int ic=khw; ic<nc-khw; ++ic) {
			int delta = *p1++ - *p2++;
			sumsq += delta*delta;
		}
	}

	nr -= 2*khw; // remember, only calculating metrics for
	nc -= 2*khw; // the portion of the image that was filtered
	CompareImages::FidelityMetrics metrics = { (float)sumsq/(float)(nr*nc), 0.f};
	float rms = sqrt(metrics.mse);
	metrics.psnr = 10*log10(255.f/rms);

	return metrics;
}