// MedianFilterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MedianFilterApp.h"
#include "MedianFilterDlg.h"
#include "AddNoise.h"
#include "MedianFilter.h"
#include "CompareImages.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CMedianFilterDlg dialog



CMedianFilterDlg::CMedianFilterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMedianFilterDlg::IDD, pParent)
	, m_percentageShotNoise(.05f)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMedianFilterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ORIG_IMAGE, m_origImage);
	DDX_Control(pDX, IDC_NOISY_IMAGE, m_noisyImage);
	DDX_Control(pDX, IDC_FILTERED_IMAGE, m_filteredImage);
	DDX_Text(pDX, IDC_PERCENTAGE_EDIT, m_percentageShotNoise);
	DDV_MinMaxFloat(pDX, m_percentageShotNoise, 0, 1.0);
	DDX_Control(pDX, IDC_MASK_SIZE_COMBO, m_medFiltMaskSize);
	DDX_Control(pDX, IDC_METHOD_COMBO, m_implMethod);
	DDX_Control(pDX, IDC_MSE_EDIT, m_mse);
	DDX_Control(pDX, IDC_PSNR_EDIT, m_psnr);
	DDX_Control(pDX, IDC_TIME_EDIT, m_time);
}

BEGIN_MESSAGE_MAP(CMedianFilterDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_BN_CLICKED(IDC_FILTER_BUTTON, OnBnClickedFilterButton)
	ON_CBN_SELCHANGE(IDC_METHOD_COMBO, OnSelChangeMethodCombo)
END_MESSAGE_MAP()


// CMedianFilterDlg message handlers

BOOL CMedianFilterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_medFiltMaskSize.SetCurSel(0);
	m_implMethod.SetCurSel(0);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMedianFilterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMedianFilterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		try {

			if (m_apOrigBitmap.get())
				m_apOrigBitmap->render(m_origImage.GetSafeHwnd());

			if (m_apNoisyBitmap.get())
				m_apNoisyBitmap->render(m_noisyImage.GetSafeHwnd());

			if (m_apProcessedBitmap.get())
				m_apProcessedBitmap->render(m_filteredImage.GetSafeHwnd());

            CDialog::OnPaint();

		} catch (exception &e) {

			this->MessageBox(e.what(), _T("Draw Error"), MB_OK|MB_ICONERROR);
			this->EndDialog(IDOK);

		} catch (CException *e) {

			e->ReportError(MB_OK|MB_ICONERROR);
			this->EndDialog(IDOK);

		}
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMedianFilterDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CMedianFilterDlg::OnFileLoad()
{
	// prompt for image filename ...
	CFileDialog dlg(TRUE, // construct a File Load dialog
					_T(".bmp"),
					_T(""),
					OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,
					_T("BMP Files (*.bmp)|*.bmp||"),
					NULL);

	try {

		this->UpdateData();
		if (IDOK == dlg.DoModal()) {
			m_apOrigBitmap = auto_ptr<Image8bpp>(new Image8bpp(dlg.GetPathName()));
			m_apNoisyBitmap = auto_ptr<Image8bpp>(AddNoise::SaltAndPepper(m_apOrigBitmap.get(), m_percentageShotNoise));
		}

		this->OnPaint();
		this->GetDlgItem(IDC_FILTER_BUTTON)->EnableWindow(TRUE);

	} catch (exception &e) {

		this->MessageBox(e.what(), _T("Error"), MB_OK|MB_ICONERROR);

	}
}

void CMedianFilterDlg::OnBnClickedOk()
{
	if (IDYES == this->MessageBox(_T("Quit Application?"), _T("Confirm Exit"), MB_YESNO|MB_ICONQUESTION))
		OnOK();
}

void CMedianFilterDlg::OnBnClickedFilterButton()
{
	this->BeginWaitCursor();

	// generate a new noisy image
	this->UpdateData();
	m_apNoisyBitmap
		= auto_ptr<Image8bpp>(AddNoise::SaltAndPepper(m_apOrigBitmap.get(), m_percentageShotNoise));

	// this image will contain the cleaned-up image
	m_apProcessedBitmap = 
		auto_ptr<Image8bpp>(new Image8bpp(m_apNoisyBitmap->getHeight(), m_apNoisyBitmap->getWidth()));

	CString sMaskSize;
	m_medFiltMaskSize.GetLBText(m_medFiltMaskSize.GetCurSel(), sMaskSize);

	// instantiate object that does the grunt work of filtering the image
	MedianFilter medFilt( atoi((LPCSTR)sMaskSize) );
	float us = 
		medFilt.processImage(m_apNoisyBitmap.get(), 
		                     m_apProcessedBitmap.get(),
						     (MedianFilter::Implementation)m_implMethod.GetCurSel());

	// now that we have filtered the image, display image fidelity computations
	CompareImages::FidelityMetrics metrics 
		= CompareImages::calcFidelityMetrics(m_apOrigBitmap.get(), 
		                                     m_apProcessedBitmap.get(),
											 medFilt.getKernelHalfWidth());
	char mseBuf[20], psnrBuf[20];
	_gcvt(metrics.mse, 10, mseBuf);
	_gcvt(metrics.psnr, 10, psnrBuf);
	m_mse.SetWindowText(mseBuf);
	m_psnr.SetWindowText(psnrBuf);

	// display how long it took to process the image
	char timeBuf[20];
	_gcvt(us, 10, timeBuf);
	m_time.SetWindowText(timeBuf);
    
	this->EndWaitCursor();
	this->OnPaint(); // render the images
}

void CMedianFilterDlg::OnSelChangeMethodCombo()
{
	// Specifying kernel size doesn't make sense for fixed mask sizes!
	BOOL bDisable = (MedianFilter::FIXED_3x3==m_implMethod.GetCurSel() ||
		             MedianFilter::FIXED_5x5==m_implMethod.GetCurSel());
	m_medFiltMaskSize.EnableWindow(!bDisable);
}
