function [A, D] = a_trous_dwt(I, N)
%
% A_TROUS_DWT   2D Discrete Wavelet Transform via "algorithme a trous"
%    [A, D] = A_TROUS_DWT(I, N)
%
%    A: approximation image
%    D: 3-dimensional array where each plane, i.e. D(:,:,i), contains
%       the i'th detail image
%    N: # wavelet decompositions
%

% generate 2D low-pass filter from cubic B-spline
B3 = [1/16 1/4 3/8 1/4 1/16];
h = B3'*B3;

A = double(I);
for level  = 1:N
    approx(:,:,level) = conv2(A, h, 'same');
    D(:,:,level) = A - approx(:,:,level);
    A = approx(:,:,level);    
end