function H = haar_basis(N)
%
% HAAR_BASIS   returns Haar basis of size NxN
% 
% H = 1/sqrt(2)  1/sqrt(2)  0  0 ...
%     1/sqrt(2) -1/sqrt(2)  0  0 ...
%     0  0       1/sqrt(2)  1/sqrt(2) ...
%     0  0       1/sqrt(2) -1/sqrt(2) ...
%     ...
%
%

haar_wavelet = [1 1; 1 -1];
H = (1/sqrt(2)) .* kron(eye(N/2),haar_wavelet);