#ifndef _HPI_H_
#define _HPI_H_

#include <windows.h>
#include <vector>
#include <string>
#include "mex.h"

namespace Qureshi {

	class HPI {

	public:

		HPI(std::string filename);
		~HPI();

		// connects to EVM, performs handshake, returns image dimensions
		std::pair<int,int> init();

		// also the # of wavelet decompositions
		void sendImage(const mxArray *pImage, int nLevels);

		// assumes pImage has already been properly allocated
		void readImage(mxArray *pImage);

	private:

		// returns pointer to start of pixel data
		unsigned char *colMajor2rowMajor(const mxArray *pImage, int nr, int nc);
		
		std::pair<int, int> handshake(); // pair.first = # rows, pair.second = # cols 

		std::string m_programFile;

		HANDLE m_hEvm, m_hEvent;

        LPVOID m_hHpi;

		std::pair<int,int> m_imageRowsCols;

		std::vector<unsigned char> m_buf; // used both for transmit AND receive

		void *m_pTargetInputBuf,
			 *m_pTargetOutputBuf;
	};

} // namespace Qureshi

#endif // _HPI_H_