#include <board.h> /* EVM library */
#include <stdio.h>
#define _TI_ENHANCED_MATH_H 1
#include <math.h>
#include <img_histogram.h> /* IMGLIB */
#include "image.h" /* birds image, along with image dimensions */

/* Input & output buffer both will not fit in
   internal chip RAM, this pragma places the 
   output buffer in off-chip RAM */
#pragma DATA_SECTION (out_img, "SBSRAM"); 
unsigned char out_img[N_PIXELS];

/* image histogram goes here, the pragma
   aligns the buffer on a 4-byte boundary
   which is required by IMGLIB */
#pragma DATA_ALIGN (hist, 4)
unsigned short hist[256];

/* scratch buffer needed by IMGLIB */
#pragma DATA_ALIGN (t_hist, 4)
unsigned short t_hist[1024];

/* pixel mapping function */
#pragma DATA_ALIGN (T_r, 4)
unsigned short T_r[256];

#define FIXED_POINT 0 /* 0=floating point, 1=fixed point */
#if FIXED_POINT

unsigned int cumsum; // 32-bit accummulator

#else // floating-point

const float num_pixels = (float)N_PIXELS;
float cumsum;

#endif /* FIXED_POINT */

void histeq()
{
	int ii = 0;
	cumsum = 0;

	/* buffers must be initialized to zero */
	memset(t_hist, 0, sizeof(unsigned short)*1024);
	memset(hist, 0, sizeof(unsigned short)*256);
	
	/* use IMGLIB to compute image histogram */
	IMG_histogram(in_img, N_PIXELS, 1, t_hist, hist);
	
	/* form gray-level transform function T(r) = CDF */
#if FIXED_POINT

	for (ii=0; ii<256; ++ii) {
		cumsum += (hist[ii] << 2);
		T_r[ii] = (255*cumsum) >> 16;
	}
	
#else

	for (ii=0; ii<256; ++ii) {
		cumsum += hist[ii];
		/* +0.5 followed by integer truncation accomplishes rounding */
		T_r[ii] = (255.f*cumsum/num_pixels) + 0.5;
	}

#endif /* FIXED_POINT */

	/* apply histogram equalization transform function */
	for (ii=0 ; ii<N_PIXELS; ++ii)
		out_img[ii] = T_r[in_img[ii]];
}

int main(void)
{
	evm_init(); /* initialize the board */
	histeq();
	printf("histogram equalization completed\n");	
}
