;******************************************************************************
;* TMS320C6x C/C++ Codegen                                    PC Version 4.36 *
;* Date/Time created: Sat Dec 25 22:15:31 2004                                *
;******************************************************************************

;******************************************************************************
;* GLOBAL FILE PARAMETERS                                                     *
;*                                                                            *
;*   Architecture      : TMS320C670x                                          *
;*   Optimization      : Enabled at level 3                                   *
;*   Optimizing for    : Speed                                                *
;*                       Based on options: -o3, no -ms                        *
;*   Endian            : Little                                               *
;*   Interrupt Thrshld : Disabled                                             *
;*   Memory Model      : Small                                                *
;*   Calls to RTS      : Near                                                 *
;*   Pipelining        : Enabled                                              *
;*   Speculative Load  : Disabled                                             *
;*   Memory Aliases    : Presume are aliases (pessimistic)                    *
;*   Debug Info        : COFF Debug                                           *
;*                                                                            *
;******************************************************************************

	.asg	A15, FP
	.asg	B14, DP
	.asg	B15, SP
	.global	$bss

	.file	"histeq.c"
	.global	_in_img
	.bss	_in_img,16384,4
	.sym	_in_img,_in_img, 60, 2, 131072,, 16384
	.global	_out_img
_out_img:	.usect	"SBSRAM",16384,4
	.sym	_out_img,_out_img, 60, 2, 131072,, 16384
	.global	_hist
	.bss	_hist,512,4
	.sym	_hist,_hist, 61, 2, 4096,, 256
	.global	_t_hist
	.bss	_t_hist,2048,4
	.sym	_t_hist,_t_hist, 61, 2, 16384,, 1024
	.global	_T_r
	.bss	_T_r,512,4
	.sym	_T_r,_T_r, 61, 2, 4096,, 256
	.global	_start
	.bss	_start,4,4
	.sym	_start,_start, 14, 2, 32
	.global	_stop
	.bss	_stop,4,4
	.sym	_stop,_stop, 14, 2, 32
	.global	_overhead
	.bss	_overhead,4,4
	.sym	_overhead,_overhead, 14, 2, 32
	.global	_t
	.bss	_t,4,4
	.sym	_t,_t, 14, 2, 32

	.sect	".cinit:c"
	.align	8
	.field  	(CIR - $) - 8, 32
	.field  	_num_pixels+0,32
	.word	046800000h		; _num_pixels @ 0

	.sect	".text"
	.global	_num_pixels
_num_pixels:	.usect	".bss:c",4,4
	.sym	_num_pixels,_num_pixels, 6, 2, 32
	.global	_cumsum
	.bss	_cumsum,4,4
	.sym	_cumsum,_cumsum, 6, 2, 32
;	c:\TIC6701EVM\c6000\cgtools\bin\opt6x.exe -v6700 -q -s -O3 C:\DOCUME~1\sq\LOCALS~1\Temp\TI3224_2 C:\DOCUME~1\sq\LOCALS~1\Temp\TI3224_5 -w C:/Documents and Settings/sq/My Documents/Book/CD-ROM/Chap3/histogram_equalization_profile/Debug 

	.sect	".text"
	.global	_histeq
	.sym	_histeq,_histeq, 46, 2, 0
	.func	50
;----------------------------------------------------------------------
;  50 | clock_t histeq()                                                       
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _histeq                                                     *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,B10,B11,B12,SP                    *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,B10,B11,B12,DP,SP                 *
;*   Local Frame Size  : 8 Args + 0 Auto + 24 Save = 32 byte                  *
;******************************************************************************

;******************************************************************************
;*                                                                            *
;* Using -g (debug) with optimization (-o3) may disable key optimizations!    *
;*                                                                            *
;******************************************************************************
_histeq:
;** --------------------------------------------------------------------------*
	.line	2
;----------------------------------------------------------------------
;  52 | int ii = 0;                                                            
;----------------------------------------------------------------------
	.sym	C$1,10, 29, 4, 32
	.sym	C$2,11, 29, 4, 32
	.sym	Y$0,20, 6, 4, 32
	.sym	Y$1,4, 14, 4, 32
	.sym	L$2,23, 4, 4, 32
	.sym	L$1,11, 4, 4, 32
	.sym	U$37,10, 14, 4, 32
	.sym	U$47,20, 28, 4, 32
	.sym	U$40,21, 28, 4, 32
	.sym	K$26,22, 29, 4, 32
	.sym	U$27,28, 29, 4, 32
	.sym	K$20,26, 6, 4, 32
	.sym	K$22,27, 6, 4, 32
	.sym	U$17,10, 29, 4, 32
;** 53	-----------------------    cumsum = 0.0F;
;** 56	-----------------------    C$2 = &t_hist[0];
;** 56	-----------------------    memset(C$2, 0, 2048u);
;** 57	-----------------------    C$1 = &hist[0];
;** 57	-----------------------    memset(C$1, 0, 512u);
;** 60	-----------------------    IMG_histogram(&in_img, 16384, 1, C$2, C$1);
;** 75	-----------------------    start = clock();
;** 76	-----------------------    L$1 = 256;
;**  	-----------------------    U$27 = &T_r[0];
;**  	-----------------------    K$22 = 6.103515625e-5F;
;**  	-----------------------    K$20 = 255.0F;
;**  	-----------------------    U$17 = C$1;
;**  	-----------------------    #pragma MUST_ITERATE(256, 256, 256)
;**  	-----------------------    #pragma LOOP_FLAGS(5120u)
           STW     .D2T2   B12,*SP--(32)     ; |51| 
           STW     .D2T2   B11,*+SP(28)      ; |51| 
           STW     .D2T2   B10,*+SP(24)      ; |51| 
           STW     .D2T2   B3,*+SP(20)       ; |51| 
           STW     .D2T1   A11,*+SP(16)      ; |51| 
           STW     .D2T1   A10,*+SP(12)      ; |51| 
	.line	4
;----------------------------------------------------------------------
;  53 | cumsum = 0;                                                            
;----------------------------------------------------------------------
           ZERO    .D1     A0                ; |53| 
           STW     .D2T1   A0,*+DP(_cumsum)  ; |53| 
	.line	7
;----------------------------------------------------------------------
;  56 | memset(t_hist, 0, sizeof(unsigned short)*1024);                        
;----------------------------------------------------------------------
           CALL    .S1     _memset           ; |56| 
           MVK     .S2     (_t_hist-$bss),B4 ; |56| 
           MVKL    .S2     RL0,B3            ; |56| 
           ADD     .D2     DP,B4,B10         ; |56| 
           MVKH    .S2     RL0,B3            ; |56| 

           ZERO    .D2     B4                ; |56| 
||         MV      .L1X    B10,A4            ; |56| 
||         MVK     .S1     0x800,A6          ; |56| 

RL0:       ; CALL OCCURS                     ; |56| 
           MV      .S1X    B10,A11           ; |56| 
	.line	8
;----------------------------------------------------------------------
;  57 | memset(hist, 0, sizeof(unsigned short)*256);                           
;----------------------------------------------------------------------
           CALL    .S1     _memset           ; |57| 
           MVK     .S2     (_hist-$bss),B4   ; |57| 
           ADD     .D2     DP,B4,B10         ; |57| 
           MVKL    .S2     RL1,B3            ; |57| 
           ZERO    .D2     B4                ; |57| 

           MV      .L1X    B10,A4            ; |57| 
||         MVKH    .S2     RL1,B3            ; |57| 
||         MVK     .S1     0x200,A6          ; |57| 

RL1:       ; CALL OCCURS                     ; |57| 
           MV      .S1X    B10,A10           ; |57| 
	.line	11
;----------------------------------------------------------------------
;  60 | IMG_histogram(in_img, N_PIXELS, 1, t_hist, hist);                      
;  63 | #if FIXED_POINT                                                        
;  64 | start = clock(); /* begin "profile area" */                            
;  65 | for (ii=0; ii<256; ++ii) {                                             
;  66 |         cumsum += (hist[ii] << 2);                                     
;  67 |         T_r[ii] = (unsigned short) (255*cumsum) >> 16;                 
;  69 | stop = clock(); /* end "profile area" */                               
;  70 | t = stop-start-overhead;                                               
;  71 | printf("Fixed point compute T_r cycles: %d\n", t);                     
;  73 | #else                                                                  
;----------------------------------------------------------------------
           CALL    .S1     _IMG_histogram    ; |60| 
           MVKL    .S2     RL2,B3            ; |60| 
           MVK     .S2     0x4000,B4         ; |60| 
           MVK     .S1     (_in_img-$bss),A0 ; |60| 
           MV      .L2X    A11,B6            ; |60| 

           MVKH    .S2     RL2,B3            ; |60| 
||         MVK     .S1     0x1,A6            ; |60| 
||         ADD     .L1X    DP,A0,A4          ; |60| 
||         MV      .D1     A10,A8            ; |60| 

RL2:       ; CALL OCCURS                     ; |60| 
	.line	26
;----------------------------------------------------------------------
;  75 | start = clock(); /* begin "profile area" */                            
;----------------------------------------------------------------------
           CALL    .S1     _clock            ; |75| 
           MVKL    .S2     RL3,B3            ; |75| 
           MVKH    .S2     RL3,B3            ; |75| 
           NOP             3
RL3:       ; CALL OCCURS                     ; |75| 
           STW     .D2T1   A4,*+DP(_start)   ; |75| 
	.line	27
;----------------------------------------------------------------------
;  76 | for (ii=0; ii<256; ++ii) {                                             
;----------------------------------------------------------------------
           ZERO    .D1     A0

           MVKH    .S1     0x38800000,A0
||         ZERO    .D2     B10
||         MVK     .S2     (_T_r-$bss),B4

           ADD     .D2     DP,B4,B12
||         MVKH    .S2     0x437f0000,B10
||         MV      .L2X    A0,B11
||         MVK     .S1     0x100,A11         ; |76| 

;*----------------------------------------------------------------------------*
;*   SOFTWARE PIPELINE INFORMATION
;*      Disqualified loop: Loop contains a call
;*----------------------------------------------------------------------------*
L1:    
;**	-----------------------g2:
;** 77	-----------------------    cumsum = Y$0 = cumsum+*U$17++;
;** 78	-----------------------    *U$27++ = (unsigned short)_round((double)(Y$0*K$20*K$22));
;** 79	-----------------------    if ( --L$1 ) goto g2;
	.line	28
;----------------------------------------------------------------------
;  77 | cumsum += hist[ii];                                                    
;----------------------------------------------------------------------
           LDHU    .D1T1   *A10++,A0         ; |77| 
           LDW     .D2T2   *+DP(_cumsum),B4  ; |77| 
           NOP             3
           INTSPU  .L1     A0,A0             ; |77| 
           NOP             3
           ADDSP   .L2X    A0,B4,B4          ; |77| 
           NOP             3
           STW     .D2T2   B4,*+DP(_cumsum)  ; |77| 
	.line	29
;----------------------------------------------------------------------
;  78 | T_r[ii] = round(255.f*cumsum/num_pixels);                              
;----------------------------------------------------------------------
           MPYSP   .M2     B10,B4,B4         ; |78| 
           MVKL    .S2     RL4,B3            ; |78| 
           MVKH    .S2     RL4,B3            ; |78| 
           NOP             1
           MPYSP   .M2     B11,B4,B4         ; |78| 
           NOP             1
           CALL    .S1     __round           ; |78| 
           NOP             1
           SPDP    .S2     B4,B5:B4          ; |78| 
           NOP             1
           MV      .S1X    B5,A5             ; |78| 
           MV      .S1X    B4,A4             ; |78| 
RL4:       ; CALL OCCURS                     ; |78| 
           CALL    .S1     __fixdu           ; |78| 
           MVKL    .S2     RL5,B3            ; |78| 
           MVKH    .S2     RL5,B3            ; |78| 
           NOP             3
RL5:       ; CALL OCCURS                     ; |78| 
           MV      .S2X    A4,B4             ; |78| 
           STH     .D2T2   B4,*B12++         ; |78| 
	.line	30
           SUB     .D1     A11,1,A1          ; |79| 
   [ A1]   B       .S1     L1                ; |79| 
           SUB     .D1     A11,1,A11         ; |79| 
           NOP             4
           ; BRANCH OCCURS                   ; |79| 
;** --------------------------------------------------------------------------*
;** 80	-----------------------    stop = Y$1 = clock();
;** 81	-----------------------    t = U$37 = Y$1-start-overhead;
;** 82	-----------------------    printf((const char *)"Floating point compute T_r cycles: %d\n", U$37);
;** 87	-----------------------    // LOOP BELOW UNROLLED BY FACTOR(4)
;** 87	-----------------------    L$2 = 4096;
;**  	-----------------------    U$47 = &out_img[-4];
;**  	-----------------------    U$40 = &in_img[-4];
;**  	-----------------------    K$26 = &T_r[0];
;**  	-----------------------    #pragma MUST_ITERATE(4096, 4096, 4096)
;**  	-----------------------    #pragma LOOP_FLAGS(4098u)
;**	-----------------------g5:
;** 88	-----------------------    *(U$47 += 4) = K$26[*(U$40 += 4)];
;** 88	-----------------------    U$47[1] = K$26[U$40[1]];
;** 88	-----------------------    U$47[2] = K$26[U$40[2]];
;** 88	-----------------------    U$47[3] = K$26[U$40[3]];
;** 88	-----------------------    if ( --L$2 ) goto g5;
	.line	31
;----------------------------------------------------------------------
;  80 | stop = clock(); /* end "profile area" */                               
;----------------------------------------------------------------------
;*----------------------------------------------------------------------------*
;*   SOFTWARE PIPELINE INFORMATION
;*
;*      Loop source line                 : 87
;*      Loop opening brace source line   : 88
;*      Loop closing brace source line   : 88
;*      Loop Unroll Multiple             : 4x
;*      Known Minimum Trip Count         : 4096
;*      Known Maximum Trip Count         : 4096
;*      Known Max Trip Count Factor      : 4096
;*      Loop Carried Dependency Bound(^) : 0
;*      Unpartitioned Resource Bound     : 6
;*      Partitioned Resource Bound(*)    : 6
;*      Resource Partition:
;*                                A-side   B-side
;*      .L units                     0        0     
;*      .S units                     1        0     
;*      .D units                     6*       6*    
;*      .M units                     0        0     
;*      .X cross paths               0        0     
;*      .T address paths             6*       6*    
;*      Long read paths              2        2     
;*      Long write paths             0        0     
;*      Logical  ops (.LS)           0        0     (.L or .S unit)
;*      Addition ops (.LSD)          2        3     (.L or .S or .D unit)
;*      Bound(.L .S .LS)             1        0     
;*      Bound(.L .S .D .LS .LSD)     3        3     
;*
;*      Searching for software pipeline schedule at ...
;*         ii = 6  Schedule found with 4 iterations in parallel
;*
;*      Register Usage Table:
;*          +---------------------------------+
;*          |AAAAAAAAAAAAAAAA|BBBBBBBBBBBBBBBB|
;*          |0000000000111111|0000000000111111|
;*          |0123456789012345|0123456789012345|
;*          |----------------+----------------|
;*       0: |*******         |**  *****       |
;*       1: |*******         |**  *** *       |
;*       2: |*******         |**  *****       |
;*       3: |*******         |**  *****       |
;*       4: |**** **         |**  *****       |
;*       5: |*******         |**  *****       |
;*          +---------------------------------+
;*
;*      Done
;*
;*      Epilog not removed
;*      Collapsed epilog stages     : 0
;*      Collapsed prolog stages     : 3
;*      Minimum required memory pad : 0 bytes
;*
;*      For further improvement on this loop, try option -mh4
;*
;*      Minimum safe trip count     : 3 (after unrolling)
;*----------------------------------------------------------------------------*
;*       SETUP CODE
;*
;*                  MV              A6,B5
;*                  MV              A3,B4
;*                  MV              A0,B6
;*                  ADD             1,B5,B5
;*                  ADD             1,B4,B4
;*
;*        SINGLE SCHEDULED ITERATION
;*
;*        C24:
;*   0              LDBU    .D2T2   *++B4(4),B8       ; |88| 
;*   1              NOP             2
;*   3              LDBU    .D1T1   *++A3(4),A5       ; |88| 
;*       ||         LDBU    .D2T2   *+B4(1),B8        ; |88| 
;*   4              NOP             2
;*   6              ADD     .S2     B8,B8,B8          ; |88| 
;*       ||         LDBU    .D1T1   *+A3(3),A5        ; |88| 
;*   7              LDBU    .D2T2   *+B8[B6],B7       ; |88| 
;*   8              NOP             1
;*   9              ADD     .S1     A5,A5,A5          ; |88| 
;*  10              LDBU    .D1T1   *+A5[A0],A4       ; |88| 
;*       ||         ADD     .S2     B8,B8,B7          ; |88| 
;*  11              LDBU    .D2T2   *+B7[B6],B7       ; |88| 
;*  12              NOP             1
;*  13              ADD     .L1     A5,A5,A4          ; |88| 
;*       || [ B0]   SUB     .L2     B0,1,B0           ; |88| 
;*  14              STB     .D2T2   B7,*++B5(4)       ; |88| 
;*       ||         LDBU    .D1T1   *+A4[A0],A4       ; |88| 
;*       || [ B0]   B       .S1     C24               ; |88| 
;*  15              NOP             1
;*  16              STB     .D2T2   B7,*+B5(1)        ; |88| 
;*  17              STB     .D1T1   A4,*++A6(4)       ; |88| 
;*  18              NOP             1
;*  19              STB     .D1T1   A4,*+A6(3)        ; |88| 
;*                  ; BRANCH OCCURS                   ; |88| 
;*----------------------------------------------------------------------------*
L2:    ; PIPED LOOP PROLOG
           CALL    .S2     _clock            ; |80| 
           NOP             3
           MVKL    .S2     RL6,B3            ; |80| 
           MVKH    .S2     RL6,B3            ; |80| 
RL6:       ; CALL OCCURS                     ; |80| 
           NOP             1
           STW     .D2T1   A4,*+DP(_stop)    ; |80| 
	.line	32
;----------------------------------------------------------------------
;  81 | t = stop-start-overhead;                                               
;----------------------------------------------------------------------
           LDW     .D2T2   *+DP(_start),B4   ; |81| 
           LDW     .D2T2   *+DP(_overhead),B5 ; |81| 
           NOP             3
           SUB     .L1X    A4,B4,A0          ; |81| 
           SUB     .L1X    A0,B5,A10         ; |81| 
           STW     .D2T1   A10,*+DP(_t)      ; |81| 
	.line	33
;----------------------------------------------------------------------
;  82 | printf("Floating point compute T_r cycles: %d\n", t);                  
;  84 | #endif                                                                 
;----------------------------------------------------------------------
           CALL    .S2     _printf           ; |82| 
           NOP             1
           MVKL    .S1     SL1+0,A0          ; |82| 
           MVKH    .S1     SL1+0,A0          ; |82| 

           MVKL    .S2     RL7,B3            ; |82| 
||         STW     .D2T1   A0,*+SP(4)        ; |82| 

           MVKH    .S2     RL7,B3            ; |82| 
||         STW     .D2T1   A10,*+SP(8)       ; |82| 

RL7:       ; CALL OCCURS                     ; |82| 
	.line	38
;----------------------------------------------------------------------
;  87 | for (ii=0 ; ii<N_PIXELS; ++ii)                                         
;  88 |         out_img[ii] = T_r[in_img[ii]];                                 
;----------------------------------------------------------------------
           NOP             1
           MVK     .S2     0x1,B1            ; init prolog collapse predicate
           MVC     .S2     CSR,B9
           MVK     .S2     0x1000,B7         ; |87| 
           MVK     .S2     (_T_r-$bss),B5

           MVK     .S1     (_in_img-4-$bss),A0
||         MVKL    .S2     _out_img-4,B4

           ADD     .S1X    DP,A0,A3
||         ADD     .D2     DP,B5,B6
||         MVKH    .S2     _out_img-4,B4

           MVK     .S1     0x3,A1            ; init prolog collapse predicate
||         SUB     .D2     B7,1,B0
||         ADD     .S2X    DP,A0,B5
||         AND     .L2     -2,B9,B7
||         MV      .L1X    B4,A6

           MVK     .S1     0x2,A2            ; init prolog collapse predicate
||         ADD     .D2     1,B4,B5
||         ADD     .L2     1,B5,B4
||         MV      .L1X    B6,A0
||         MVC     .S2     B7,CSR            ; interrupts off

;** --------------------------------------------------------------------------*
L3:    ; PIPED LOOP KERNEL

   [ B0]   B       .S1     L3                ; |88| <0,14> 
|| [!A1]   LDBU    .D1T1   *+A4[A0],A4       ; |88| <0,14> 
|| [!A1]   STB     .D2T2   B7,*++B5(4)       ; |88| <0,14> 

           ADD     .S1     A5,A5,A5          ; |88| <1,9> 
|| [!B1]   LDBU    .D1T1   *++A3(4),A5       ; |88| <2,3> 
|| [!B1]   LDBU    .D2T2   *+B4(1),B8        ; |88| <2,3> 

   [!A1]   STB     .D2T2   B7,*+B5(1)        ; |88| <0,16> 
|| [!A2]   LDBU    .D1T1   *+A5[A0],A4       ; |88| <1,10> 
||         ADD     .S2     B8,B8,B7          ; |88| <1,10> 

   [!A1]   STB     .D1T1   A4,*++A6(4)       ; |88| <0,17> 
|| [!A2]   LDBU    .D2T2   *+B7[B6],B7       ; |88| <1,11> 

   [ A2]   SUB     .S1     A2,1,A2           ; <0,18> 
|| [!B1]   LDBU    .D1T1   *+A3(3),A5        ; |88| <2,6> 
||         ADD     .S2     B8,B8,B8          ; |88| <2,6> 
||         LDBU    .D2T2   *++B4(4),B8       ; |88| <3,0> 

   [ B1]   SUB     .S2     B1,1,B1           ; <0,19> 
|| [ A1]   SUB     .S1     A1,1,A1           ; <0,19> 
|| [!A1]   STB     .D1T1   A4,*+A6(3)        ; |88| <0,19> 
|| [ B0]   SUB     .L2     B0,1,B0           ; |88| <1,13> 
||         ADD     .L1     A5,A5,A4          ; |88| <1,13> 
|| [!B1]   LDBU    .D2T2   *+B8[B6],B7       ; |88| <2,7> 

;** --------------------------------------------------------------------------*
L4:    ; PIPED LOOP EPILOG
;** 90	-----------------------    return U$37;

           STB     .D2T2   B7,*++B5(4)       ; |88| (E) <1,14> 
||         LDBU    .D1T1   *+A4[A0],A3       ; |88| (E) <1,14> 

           ADD     .S1     A5,A5,A5          ; |88| (E) <2,9> 
||         LDBU    .D1T1   *++A3(4),A4       ; |88| (E) <3,3> 
||         LDBU    .D2T2   *+B4(1),B4        ; |88| (E) <3,3> 

           LDBU    .D1T1   *+A5[A0],A3       ; |88| (E) <2,10> 
||         ADD     .S2     B8,B8,B7          ; |88| (E) <2,10> 
||         STB     .D2T2   B7,*+B5(1)        ; |88| (E) <1,16> 

           STB     .D1T1   A4,*++A6(4)       ; |88| (E) <1,17> 
||         LDBU    .D2T2   *+B7[B6],B7       ; |88| (E) <2,11> 

           ADD     .D2     B8,B8,B4          ; |88| (E) <3,6> 
||         LDBU    .D1T1   *+A3(3),A4        ; |88| (E) <3,6> 

           ADD     .S1     A5,A5,A3          ; |88| (E) <2,13> 
||         LDBU    .D2T2   *+B4[B6],B4       ; |88| (E) <3,7> 
||         STB     .D1T1   A3,*+A6(3)        ; |88| (E) <1,19> 

           LDBU    .D1T1   *+A3[A0],A3       ; |88| (E) <2,14> 
||         STB     .D2T2   B7,*++B5(4)       ; |88| (E) <2,14> 

           ADD     .D1     A4,A4,A4          ; |88| (E) <3,9> 

           STB     .D2T2   B7,*+B5(1)        ; |88| (E) <2,16> 
||         ADD     .S2     B4,B4,B4          ; |88| (E) <3,10> 
||         LDBU    .D1T1   *+A4[A0],A0       ; |88| (E) <3,10> 

           LDBU    .D2T2   *+B4[B6],B4       ; |88| (E) <3,11> 
||         STB     .D1T1   A3,*++A6(4)       ; |88| (E) <2,17> 

           NOP             1

           ADD     .S1     A4,A4,A3          ; |88| (E) <3,13> 
||         STB     .D1T1   A3,*+A6(3)        ; |88| (E) <2,19> 

           LDBU    .D1T1   *+A3[A0],A0       ; |88| (E) <3,14> 
||         STB     .D2T2   B4,*++B5(4)       ; |88| (E) <3,14> 

           NOP             1
           STB     .D2T2   B4,*+B5(1)        ; |88| (E) <3,16> 
           STB     .D1T1   A0,*++A6(4)       ; |88| (E) <3,17> 
           MVC     .S2     B9,CSR            ; interrupts on
           STB     .D1T1   A0,*+A6(3)        ; |88| (E) <3,19> 
	.line	41
;----------------------------------------------------------------------
;  90 | return t;                                                              
;----------------------------------------------------------------------
           MV      .D1     A10,A4            ; |90| 
	.line	42

           MV      .S1X    SP,A9             ; |91| 
||         LDW     .D2T2   *+SP(20),B3       ; |91| 

           LDDW    .D2T2   *+SP(24),B11:B10  ; |91| 
||         LDW     .D1T1   *+A9(12),A10      ; |91| 

           LDW     .D2T2   *++SP(32),B12     ; |91| 
||         LDW     .D1T1   *+A9(16),A11      ; |91| 

           NOP             2
           RET     .S2     B3                ; |91| 
           NOP             5
           ; BRANCH OCCURS                   ; |91| 
	.endfunc	91,01c080c00h,32



	.sect	".text"
	.global	_main
	.sym	_main,_main, 36, 2, 0
	.func	93
;----------------------------------------------------------------------
;  93 | int main(void)                                                         
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _main                                                       *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,SP                                *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,DP,SP                             *
;*   Local Frame Size  : 16 Args + 0 Auto + 12 Save = 28 byte                 *
;******************************************************************************

;******************************************************************************
;*                                                                            *
;* Using -g (debug) with optimization (-o3) may disable key optimizations!    *
;*                                                                            *
;******************************************************************************
_main:
;** --------------------------------------------------------------------------*
	.line	2
;----------------------------------------------------------------------
;  95 | const int N = 10; /* how many times to profile */                      
;  96 | int ii = 0;                                                            
;  97 | clock_t profile = 0;                                                   
;----------------------------------------------------------------------
	.sym	Y$0,4, 14, 4, 32
	.sym	a$1,0, 14, 4, 32
	.sym	_profile,10, 14, 4, 32
	.sym	L$1,11, 4, 4, 32
;** 99	-----------------------    evm_init();
;** 100	-----------------------    start = clock();
;** 101	-----------------------    stop = Y$0 = clock();
;** 102	-----------------------    overhead = Y$0-start;
;** 104	-----------------------    L$1 = 10;
;** 97	-----------------------    profile = 0u;
;**  	-----------------------    #pragma MUST_ITERATE(10, 10, 10)
;**  	-----------------------    #pragma LOOP_FLAGS(5120u)
           STW     .D2T2   B3,*SP--(32)      ; |94| 
           STW     .D2T1   A11,*+SP(28)      ; |94| 
           STW     .D2T1   A10,*+SP(24)      ; |94| 
	.line	7
;----------------------------------------------------------------------
;  99 | evm_init(); /* initialize the board */                                 
;----------------------------------------------------------------------
           CALL    .S1     _evm_init         ; |99| 
           MVKL    .S2     RL9,B3            ; |99| 
           MVKH    .S2     RL9,B3            ; |99| 
           NOP             3
RL9:       ; CALL OCCURS                     ; |99| 
	.line	8
;----------------------------------------------------------------------
; 100 | start = clock(); /* calculate overhead of calling clock*/              
;----------------------------------------------------------------------
           CALL    .S1     _clock            ; |100| 
           MVKL    .S2     RL10,B3           ; |100| 
           MVKH    .S2     RL10,B3           ; |100| 
           NOP             3
RL10:      ; CALL OCCURS                     ; |100| 
           STW     .D2T1   A4,*+DP(_start)   ; |100| 
	.line	9
;----------------------------------------------------------------------
; 101 | stop = clock();  /* and subtract this value from The results*/         
;----------------------------------------------------------------------
           CALL    .S1     _clock            ; |101| 
           MVKL    .S2     RL11,B3           ; |101| 
           MVKH    .S2     RL11,B3           ; |101| 
           NOP             3
RL11:      ; CALL OCCURS                     ; |101| 
           STW     .D2T1   A4,*+DP(_stop)    ; |101| 
	.line	10
;----------------------------------------------------------------------
; 102 | overhead = stop - start;                                               
;----------------------------------------------------------------------
           LDW     .D2T2   *+DP(_start),B4   ; |102| 
           NOP             4
           SUB     .L2X    A4,B4,B4          ; |102| 
           STW     .D2T2   B4,*+DP(_overhead) ; |102| 
	.line	12
;----------------------------------------------------------------------
; 104 | for (; ii<N; ++ii)                                                     
;----------------------------------------------------------------------
           MVK     .S1     0xa,A0            ; |104| 
           MV      .D1     A0,A11            ; |104| 
	.line	5
           ZERO    .D1     A10               ; |97| 
;*----------------------------------------------------------------------------*
;*   SOFTWARE PIPELINE INFORMATION
;*      Disqualified loop: Loop contains a call
;*----------------------------------------------------------------------------*
L5:    
;**	-----------------------g2:
;** 105	-----------------------    a$1 = histeq()+profile;
;** 105	-----------------------    profile = a$1;
;** 105	-----------------------    if ( --L$1 ) goto g2;
	.line	13
;----------------------------------------------------------------------
; 105 | profile += histeq();                                                   
;----------------------------------------------------------------------
           CALL    .S1     _histeq           ; |105| 
           MVKL    .S2     RL12,B3           ; |105| 
           MVKH    .S2     RL12,B3           ; |105| 
           NOP             3
RL12:      ; CALL OCCURS                     ; |105| 
           SUB     .D1     A11,1,A1          ; |105| 
   [ A1]   B       .S1     L5                ; |105| 
           ADD     .S1     A10,A4,A10        ; |105| 
           SUB     .D1     A11,1,A11         ; |105| 
           NOP             3
           ; BRANCH OCCURS                   ; |105| 
;** --------------------------------------------------------------------------*
;** 107	-----------------------    printf((const char *)"average time to compute T_r is %.2f cycles\n", (double)((float)profile/10.0F));
;** 107	-----------------------    return 0;
	.line	15
;----------------------------------------------------------------------
; 107 | printf("average time to compute T_r is %.2f cycles\n", (float)profile/(
;     | float)N);                                                              
;----------------------------------------------------------------------
           CALL    .S1     __divf            ; |107| 
           MVKL    .S2     RL14,B3           ; |107| 
           INTSPU  .L1     A10,A4            ; |107| 
           MVKH    .S2     RL14,B3           ; |107| 
           ZERO    .D2     B4                ; |107| 
           MVKH    .S2     0x41200000,B4     ; |107| 
RL14:      ; CALL OCCURS                     ; |107| 

           CALL    .S2     _printf           ; |107| 
||         MVKL    .S1     SL2+0,A0          ; |107| 

           MVKH    .S1     SL2+0,A0          ; |107| 
           SPDP    .S1     A4,A5:A4          ; |107| 
           STW     .D2T1   A0,*+SP(4)        ; |107| 

           STW     .D2T1   A4,*+SP(8)        ; |107| 
||         MVKL    .S2     RL15,B3           ; |107| 

           STW     .D2T1   A5,*+SP(12)       ; |107| 
||         MVKH    .S2     RL15,B3           ; |107| 

RL15:      ; CALL OCCURS                     ; |107| 
           ZERO    .D1     A4                ; |107| 
	.line	16
           LDW     .D2T1   *+SP(28),A11      ; |108| 
           LDW     .D2T1   *+SP(24),A10      ; |108| 
           LDW     .D2T2   *++SP(32),B3      ; |108| 
           NOP             4
           RET     .S2     B3                ; |108| 
           NOP             5
           ; BRANCH OCCURS                   ; |108| 
	.endfunc	108,000080c00h,32


;******************************************************************************
;* MARK THE END OF THE SCALAR INIT RECORD IN CINIT:C                          *
;******************************************************************************

CIR:	.sect	".cinit:c"
;******************************************************************************
;* STRINGS                                                                    *
;******************************************************************************
	.sect	".const"
SL1:	.string	"Floating point compute T_r cycles: %d",10,0
SL2:	.string	"average time to compute T_r is %.2f cycles",10,0
;******************************************************************************
;* UNDEFINED EXTERNAL REFERENCES                                              *
;******************************************************************************
	.global	_evm_init
	.global	_printf
	.global	__round
	.global	_IMG_histogram
	.global	_clock
	.global	_memset
	.global	__fixdu
	.global	__divf

;******************************************************************************
;* TYPE INFORMATION                                                           *
;******************************************************************************
	.sym	_clock_t, 0, 14, 13, 32
