function [J, varargout] = window_level(I, win, lev)
%
% WINDOW_LEVEL   Window and level an image
%    J = WINDOW_LEVEL(I, win, lev)
%    [J, LUT] = WINDOW_LEVEL(I, win, lev)
%
%    J: processed image
%    LUT: pixel remapping function
%    I: input image, may be UINT8 or UINT16
%

if strcmp('uint8', class(I))
    nlevels = 256;
    bpp = 8;
elseif strcmp('uint16', class(I))
    nlevels = 65536;
    bpp = 16;
else
    error('Require 8-bit or 16-bit input image');
end
max_pixel_intensity = nlevels - 1;

% construct gray-scale LUT
LUT = zeros(1, nlevels);

halfwin = floor(win/2);
a = lev - halfwin;
if a<1, a=1; end
b = a + win - 1;
if b>max_pixel_intensity, b=max_pixel_intensity, end

% 1st portion all zeros
% middle portion is a linear scaling function
ratio = max_pixel_intensity / win;
LUT(a:b) = round( ratio .* [1:win] );

% final portion all maximum pixel intensity
LUT(b+1:nlevels) = max_pixel_intensity;

% apply LUT to input image I
% NOTE: must promote to real because certain operations
%       not allowed with integer objects and add 1 because
%       MATLAB is one-based yet pixel intensities are 0-based.
J = LUT(double(I) + 1);

% if client asks for it, return the LUT
if 2==nargout, varargout{1} = LUT; end

eval( sprintf('J=%s(J);', class(I)) );