#include <board.h> /* EVM library */
#include <limits.h>
#include <stdio.h>

/* image dimensions */
#define X_SIZE 128
#define Y_SIZE 128
#define N_PIXELS X_SIZE*Y_SIZE

/* image is processed "in-place" */
unsigned char img[N_PIXELS];

/* LUT */
#define N_LEVELS 256 /* 8 bpp */
int window = N_LEVELS;
unsigned char level = 127,
              LUT[256] = {0};

void make_lut()
{
	int ii=0, jj=0, N=level-window/2;
	float ratio = (float)(N_LEVELS-1)/(float)window;

	// 1st portion is all zeros
	if (N > 0) 
		for (; ii<N; ++ii)
			LUT[ii] = 0;
	
	// 2nd portion is a linear relationship
	for (; jj<window; ++jj)
		LUT[ii+jj] = (unsigned char)( (ratio*jj)+0.5 ); // +0.5 for rounding

	// 3rd portion is just all 255s
	ii += jj;
	for (; ii<N_LEVELS; ++ii)
		LUT[ii] = N_LEVELS-1;
}

void apply_lut()
{
	int ii=0;
	for (; ii<N_PIXELS; ++ii)
		img[ii] = LUT[ img[ii] ];
}

int main(void)
{
	evm_init(); /* initialize the board */
	make_lut();
	apply_lut();
	printf("window/level completed");	
}
