// MedianFilterDlg.h : header file
//

#pragma once
#include "afxwin.h"

// forward declarations
class Image8bpp;

// CMedianFilterDlg dialog
class CMedianFilterDlg : public CDialog
{
// Construction
public:
	CMedianFilterDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_MEDIANFILTERVS_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnFileLoad();
	afx_msg void OnBnClickedOk();
	afx_msg void OnBnClickedFilterButton();
	afx_msg void OnSelChangeMethodCombo();
	DECLARE_MESSAGE_MAP()

private:
	
	CStatic m_origImage; // control that input image is rendered onto
	CStatic m_noisyImage; // control that corrupted image is rendered onto
	CStatic m_filteredImage; // control that the processed image is rendered onto
	CComboBox m_medFiltMaskSize;
	CComboBox m_implMethod;
	CEdit m_mse; // mean-squared error fidelity metric
	CEdit m_psnr; // peak signal-to-noise ratio (in dB) fidelity metric
	CEdit m_time; // time to process the image, in microseconds

	std::auto_ptr<Image8bpp> m_apOrigBitmap,
		                     m_apNoisyBitmap,
		                     m_apProcessedBitmap;

	float m_percentageShotNoise; // determines how many pixels to corrupt
};
