function varargout = SobelDemo(varargin)
% SOBELDEMO M-file for SobelDemo.fig
%      SOBELDEMO, by itself, creates a new SOBELDEMO or raises the existing
%      singleton*.
%
%      H = SOBELDEMO returns the handle to a new SOBELDEMO or the handle to
%      the existing singleton*.
%
%      SOBELDEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SOBELDEMO.M with the given input arguments.
%
%      SOBELDEMO('Property','Value',...) creates a new SOBELDEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SobelDemo_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SobelDemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help SobelDemo

% Last Modified by GUIDE v2.5 06-Aug-2004 08:38:16

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @SobelDemo_OpeningFcn, ...
                   'gui_OutputFcn',  @SobelDemo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before SobelDemo is made visible.
function SobelDemo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SobelDemo (see VARARGIN)

% Choose default command line output for SobelDemo
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% initialize main window
subplot(handles.input_image);
colormap(gray(255));
image(zeros(200));
axis off;
subplot(handles.edge_image);
colormap(gray(255));
image(zeros(200));
axis off;

% UIWAIT makes SobelDemo wait for user response (see UIRESUME)
% uiwait(handles.SobelDemo);


% --- Outputs from this function are returned to the command line.
function varargout = SobelDemo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function threshold_edit_Callback(hObject, eventdata, handles)
% hObject    handle to threshold_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of threshold_edit as text
%        str2double(get(hObject,'String')) returns contents of threshold_edit as a double


% --- Executes during object creation, after setting all properties.
function threshold_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to threshold_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on button press in edge_detect_button.
function edge_detect_button_Callback(hObject, eventdata, handles)
% hObject    handle to edge_detect_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

T = str2num(get(handles.threshold_edit, 'String'));

% get pointer to image data - I could just have easily created another
% field in the handles struct, but since it is held by a child of the axes
% object in the interest of reducing clutter I access it this way.
H = get(handles.input_image, 'Children');
I = get(H, 'CData');

% now pass I through the edge detector
try
    J = sobel_edge_detect_fixed(I, T);
    subplot(handles.edge_image);
    imagesc(double(J).*255);
    axis off;
catch
    disp(lasterr, 'Edge Detection Error');
end

% --------------------------------------------------------------------
function MenuFileLoad_Callback(hObject, eventdata, handles)
% hObject    handle to MenuFileLoad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

try
    % prompt user for input image filename
    [filename, pathname] = uigetfile( ...
        {'*.bmp;*.jpg;*.gif;*.tif', 'Image Files (*.bmp, *.jpg, *.gif, *.tif)';
        '*.bmp',  'Windows Bitmap Files (*.bmp)'; ...
        '*.jpg','JPEG Files (*.jpg)'; ...
        '*.gif','GIF Files (*.gif)'; ...
        '*.tif','TIFF (*.tif)'; ...
        '*.*',  'All Files (*.*)'}, ...
        'Select an image');
    
    if isequal(filename,0) | isequal(pathname,0)
        % do nothing, as the user clicked on cancel
    else
        % Remember that in C/C++, format strings use the \ character for
        % specifications (\t, \n, and so on) - so here replace all 
        % occurrences of \ with \\ so as not to confuse the MEX function.
        imgpath = strrep(fullfile(pathname,filename), '\', '\\');
        I = import_grayscale_image(imgpath);
        % display input image
        subplot(handles.input_image);
        imagesc(I);
        axis off;
        set(handles.edge_detect_button, 'Enable', 'on');
    end
    
catch
    errordlg(lasterr, 'File I/O Error');
end

% --------------------------------------------------------------------
function MenuFile_Callback(hObject, eventdata, handles)
% hObject    handle to MenuFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


