// SegmentationHostDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SegmentationHost.h"
#include "SegmentationDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CSegmentationDlg dialog



CSegmentationDlg::CSegmentationDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSegmentationDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSegmentationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ORIG_IMAGE, m_origImage);
	DDX_Control(pDX, IDC_PROCESSED_IMAGE, m_processedImage);
	DDX_Control(pDX, IDC_EDGE_DETECT_CHECK, m_edgeDetectCheck);
}

BEGIN_MESSAGE_MAP(CSegmentationDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
	ON_BN_CLICKED(IDC_SEGMENT_BUTTON, OnSegmentButton)
END_MESSAGE_MAP()


// CSegmentationDlg message handlers

BOOL CSegmentationDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSegmentationDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSegmentationDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		try {

			if (m_apOrigBitmap.get())
				m_apOrigBitmap->render(m_origImage.GetSafeHwnd());

			if (m_apProcessedBitmap.get())
				m_apProcessedBitmap->render(m_processedImage.GetSafeHwnd());

			CDialog::OnPaint();

		} catch (exception &e) {

			this->MessageBox(e.what(), _T("Draw Error"), MB_OK|MB_ICONERROR);
			this->EndDialog(IDOK);

		} catch (CException *e) {

			e->ReportError(MB_OK|MB_ICONERROR);
			this->EndDialog(IDOK);

		}
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSegmentationDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CSegmentationDlg::OnFileLoad()
{
	// prompt for image filename ...
	CFileDialog dlg(TRUE, // construct a File Load dialog
					_T(".bmp"),
					_T(""),
					OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,
					_T("BMP Files (*.bmp)|*.bmp||"),
					NULL);

	try {

		this->UpdateData();
		if (IDOK == dlg.DoModal()) {
			m_apOrigBitmap = auto_ptr<Image8bpp>(new Image8bpp(dlg.GetPathName()));
			m_apOrigBitmap->resize(Y_SIZE, X_SIZE);
			this->GetDlgItem(IDC_SEGMENT_BUTTON)->EnableWindow();
			this->OnPaint();
		}

	} catch (exception &e) {

		this->MessageBox(e.what(), _T("Error"), MB_OK|MB_ICONERROR);

	}
}

void CSegmentationDlg::OnSegmentButton()
{
	if (m_apOrigBitmap.get()) {

		// 1st tell the target to edge detect or just segment
		theApp.rtdx()->sendInteger( this->m_edgeDetectCheck.GetCheck()?1:0 );

		// next send the image to be processed
		theApp.rtdx()->sendImage(m_apOrigBitmap.get());

		// lastly, read the segmented image
		m_apProcessedBitmap = auto_ptr<Image8bpp>( theApp.rtdx()->readImage() );
		m_apProcessedBitmap->binarize();

		this->OnPaint();
	}
}
