function J = sobel_edge_detect(I, T)
%
% SOBEL_EDGE_DETECT   Sobel edge detection
%    J = SOBEL_EDGE_DETECT(I)
%    J = SOBEL_EDGE_DETECT(I, T)
%
%    J: binary segmented image, will be of type LOGICAL
%    I: input image
%    T: threshold
%
% NOTE: if T isn't specified, then this function uses SEGMENT_ISODATA
%       to derive a thershold, otherwise it is equivalent to 
%       SOBEL_EDGE_DETECT_FIXED.
%

I = double(I);

% compute gradient image
Gx = filter2([1 0 -1;2 0 -2;1 0 -1], I, 'valid');
Gy = filter2([-1 -2 -1;0 0 0;1 2 1], I, 'valid');
G = abs(Gx) + abs(Gy);

if 1 == nargin % using the histogram, select a good threshold 
    
    J = segment_isodata(G); 

else % binarize image using user-provided threshold value

    J = logical(zeros(size(G))); % return matrix
    indices = find(G > T);
    J(indices) = true;

end