function I = a_trous_idwt(A, D)
%
% A_TROUS_IDWT   2D Inverse Discrete Wavelet Transform via "algorithme a trous"
%    I = A_TROUS_IDWT(A, D)
%
%    I: reconstructed image
%    A: approximation image
%    D: 3-dimensional array where each plane, i.e. D(:,:,i), contains
%       the i'th detail image
%

I = A + sum(D,3); % sum along the 3rd dimension