function J = add_zero_mean_gwn(I, sigma)
%
% ADD_ZERO_MEAN_GWN   corrupt image with zero mean gaussian white noise
%    J = ADD_ZERO_MEAN_GWN(I, sigma)
%
%    J: noisy image
%    I: input image, must be UINT8 or UINT16
%    sigma: noise variance
%

if isa(I, 'uint8')
    max_pixel = 255;
elseif isa(I, 'uint16')
    max_pixel = 65535;
else
    error('Only support uint8 or uint16 images.');
end

% normalize pixel values to range [-1,1]
J = double(I)./max_pixel;

% randn returns gaussian noise with zero mean and unit variance
noise = sqrt(sigma).*randn(size(I));

% add noise with specified variance to the image
J = max_pixel .* (J + noise);

% returned image should have same class as input image
eval(sprintf('J = %s(J);', class(I)));