function D4 = daub4_basis(N)
%
% DAUB4_BASIS   returns D4 basis of size NxN
% 
% H = h0  h1 h2  h3 0   0  0 0 ...
%     h3 -h2 h1 -h0 0   0  0 0 ...
%     0   0  h0  h1 h2  h3 0 0 ...
%     0   0  h3 -h2 h1 -h0 0 0 ...
%     .                         .
%     .                         .
%     .                         .
%     h2  h3 0   0 ...      h0  h1
%     h1 -h0 0   0 ...      h3 -h2
%
% where h0,h1,h2,h3 are the D4 wavelet coefficients
%

h0=(1+sqrt(3))/(4*sqrt(2)); h1=(3+sqrt(3))/(4*sqrt(2));
h2=(3-sqrt(3))/(4*sqrt(2)); h3=(1-sqrt(3))/(4*sqrt(2));

daub4 = [ h0 h1 h2 h3; h3 -h2 h1 -h0 ];
D4 = zeros(N);

for ii=1:2:N-2
    
    row1 = zeros(1,N);
    row1(ii:ii+3) = daub4(1,:);
    row2 = zeros(1,N);
    row2(ii:ii+3) = daub4(2,:);
    
    D4(ii,:) = row1;
    D4(ii+1,:) = row2;
    
end

% periodization (wrap-around)
row1 = zeros(1,N); row1(1:2) = [h2 h3]; row1(N-1:N) = [h0 h1];
row2 = zeros(1,N); row2(1:2) = [h1 -h0]; row2(N-1:N) = [h3 -h2];
D4(N-1:N,:) = [ row1; row2 ];