function J = haar_2D_dwt(I)
%
% HAAR_2D_DWT   2D Haar Discrete Wavelet Transform (single-level)
%    J = HAAR_2D_DWT(I)
%
%    J: 2D DWT, with image split into LL, HL, HH, and LH subbands
%    I: input image, must be square
%

[M N] = size(I);
if M ~= N
    error('Only support square images.');
end

H = haar_basis(N);
P = permutation_matrix(N);

A = P*H;
B = H'*P';

J = A*double(I)*B; % forward transform