function J = haar_2d_dwt_n(I, N)
%
% HAAR_2D_DWT_N   2D Haar Discrete Wavelet Transform (multi-level)
%    J = HAAR_2D_DWT_N(I, N)
%
%    J: 2D DWT output
%    I: input image, must be square
%    N: # wavelet decompositions
%

I = double(I);
[nrows ncols] = size(I);
if nrows ~= ncols
    error('Only support square images.');
end

num_levels = log2(nrows);
if num_levels ~= floor(num_levels)
    error('Image must have power-of-2 dimensions.');
end

J = I;
H = haar_basis(2^num_levels);
for kk = num_levels:-1:num_levels-N+1
    sz = 2^kk;
    P = permutation_matrix(sz);
    J(1:sz,1:sz) = P*H(1:sz,1:sz)*J(1:sz,1:sz)*H(1:sz,1:sz)'*P';
end