#ifndef _HPI_H_
#define _HPI_H_

#include <vector>
#include <string>

// forward decls
class Image8bpp;

namespace Qureshi {

	class HPI {

	public:

		HPI(std::string filename);
		~HPI();

		// connects to EVM, performs handshake, returns image dimensions
		std::pair<int,int> init();

		// also the # of wavelet decompositions
		void sendImage(Image8bpp *pImage, int nLevels);

		// client is responsible for deallocating returned object!
		Image8bpp *readImage();

	private:

		
		std::pair<int, int> handshake(); // pair.first = # rows, pair.second = # cols 

		std::string m_programFile;

		HANDLE m_hEvm, m_hEvent;

        LPVOID m_hHpi;

		std::pair<int,int> m_imageRowsCols;

		void *m_pTargetInputBuf,
			 *m_pTargetOutputBuf;

		// scratch storage used for sending/receiving pixel data
		std::vector<Ipp8u> m_buffer;

	};

} // namespace Qureshi

#endif // _HPI_H_