% get list of all BMP files
frames_dir = 'C:\Documents and Settings\sq\My Documents\Book\appendixa\frames';
D = dir(fullfile(frames_dir,'*.bmp'));

% get dimensions of the 1st frame
frame = imread(fullfile(frames_dir, D(1).name));
frame = rgb2gray(frame);
RESIZE_NROW = 240; RESIZE_NCOL = 320;
%[RESIZE_NROW RESIZE_NCOL] = size(frame);

% calculate cropping indices
% [M N] = size(frame);
% istartrow = floor( (M-RESIZE_NROW)/2 ) + 64;
% iendrow   = istartrow + RESIZE_NROW - 1;
% istartcol = floor( (N-RESIZE_NCOL)/2 );
% iendcol   = istartcol + RESIZE_NCOL - 1;

% pre-allocate frame for conversion to movie structure
STOP_FRAME = 256;
frame = uint8(zeros(RESIZE_NROW, RESIZE_NCOL, 3));

n_frames = length(D);
for ii=1:STOP_FRAME
    disp(['Frame ' num2str(ii)]);
    % resize and make monochrome
    f = imread(fullfile(frames_dir, D(ii).name)); 
    f = rgb2gray(f);
    %f = f(istartrow:iendrow,istartcol:iendcol);
    f = imresize(f, [RESIZE_NROW RESIZE_NCOL], 'bicubic');
    frame(:,:,1) = f;
    frame(:,:,2) = f;
    frame(:,:,3) = f;
    mov(ii) = im2frame(frame);
end

output_avi_file = 'C:\Documents and Settings\sq\My Documents\Book\CD-ROM\misc\cars.avi';
movie2avi(mov, output_avi_file, 'compression', 'None');
