-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Phasedetector
-- 
-- Description:
-- The model describes a mulitplier. The output voltage source equals
-- the product of input voltages times GAIN. The model can be
-- used as a phasedetector in an analog PLL description.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- pd.vhd
-- -----------------------------------------------------------


library IEEE_proposed;
use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity PD is
   generic (GAIN          : REAL := 1.0   -- gain
           );
   port    (terminal IN1  : ELECTRICAL;   -- first input
            terminal IN2  : ELECTRICAL;   -- second input
            terminal OUTP : ELECTRICAL    -- output terminal
           );
end entity PD;

architecture BASIC of PD is
  quantity VIN1 across IN1;               -- 1 st open input branch
  quantity VIN2 across IN2;               -- 2 nd open input branch
  quantity VOUT across IOUT through OUTP; -- output branch
begin
  VOUT == GAIN*VIN1*VIN2;                 -- see PD description
end architecture BASIC;
