-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Analog PLL
-- 
-- Description:
-- The test-bench describes an analog PLL. The voltage at node N_IN
-- is frequency modulated by the first VCO (UUT2). The frequency modulated
-- voltage is available at node FM. This voltage is demodulated by the
-- PLL that consists of the phasedetector (UUT3), an analog filter (UUT4)
-- and the second VCO (UUT5). The demodulated voltage is available
-- at node OUT_PLL. The simulation should run until 200 us. 
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    VPWL(SPICE)
-- WORK                    VCO(BASIC)
-- WORK                    PD(BASIC)
-- WORK                    FILTER(TP)
-- -----------------------------------------------------------
--
-- Source:
-- section5.3_pll/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
use IEEE_proposed.ELECTRICAL_SYSTEMS.all, IEEE.MATH_REAL.all;
use WORK.all;

entity BENCH is end entity BENCH;

architecture PLL of BENCH is
   terminal N_IN, FM, PD_OUT, VCO_OUT, OUT_PLL : ELECTRICAL;
begin 

V1: entity VPWL(SPICE)        
      generic map (WAVE => 
        (0.0, 0.0, 50.0E-6, 0.0, 150.0E-6, 1.0, 200.0E-6, 1.0))
      --(time1, value1, time2, value2, ...)
      port map (P => N_IN, N => ELECTRICAL_REF);

UUT2: entity VCO(BASIC)
      generic map (F0 => 1.0E6, KF => 1.0E5, AMPL => 4.0, PHI0 => -MATH_PI/2.0)
      port map (INP => N_IN, OUTP => FM);

UUT3: entity PD(BASIC)
      generic map (GAIN => 2.5)
      port map (IN1 => FM, IN2 => VCO_OUT, OUTP => PD_OUT);

UUT4: entity FILTER(LP)
      generic map (FC => 20.0E3)
      port map (INP => PD_OUT, OUTP => OUT_PLL);

UUT5: entity VCO(BASIC)
      generic map (F0 => 1.0E6, KF => 1.0E5, AMPL => 1.0)
      port map (INP => OUT_PLL, OUTP => VCO_OUT);

end architecture PLL;
