-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      DIVIDER architecture SIMPLE
-- 
-- Description:
-- N input pulses of signal INP cause one pulse of signal OUTP.
-- The entity DIVIDER is declared in the file divider_ent.vhd.
-- The architecture is a secondary design unit. It has to be 
-- analyzed after the analysis of the entity declaration.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- 
-- -----------------------------------------------------------
--
-- Source:
-- divider_simple.vhd
-- -----------------------------------------------------------


architecture SIMPLE of DIVIDER is
begin
  process is
    variable COUNTER : INTEGER := N-1;
  begin
    wait until INP = '1';  -- process with wait, no sens. list
    COUNTER := (COUNTER + 1) mod N;
    if COUNTER = 0 then
       OUTP <= '1';
    elsif COUNTER = N/2 then
       OUTP <= '0';
    end if;
  end process;
end architecture SIMPLE;

