-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Capacitor
-- 
-- Description:
-- P1 and P2 are the element terminals. VALUE_C is the capacitance
-- in Farad.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- capacitor.vhd
-- -----------------------------------------------------------


library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity CAPACITOR is
    generic (VALUE_C         : REAL := 1.0   -- capacitance [F]
            );
    port    (terminal P1     : ELECTRICAL;   -- electrical terminal
             terminal P2     : ELECTRICAL    -- electrical terminal
            );
end entity CAPACITOR;


architecture V1 of CAPACITOR is
    quantity V across I through P1 to P2;
begin
    I == VALUE_C * V'DOT;
end architecture V1;

