-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Simple RC Subircuit
-- 
-- Description:
-- This example demonstrates how to create hierachical models.
-- The terminals T1 and T2 are connected by a resistor.
-- The terminals T2 and T3 are connected by a capacitor. 
-- It is required that the element values are positive.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- WORK                    RESISTOR(V1)
-- WORK                    CAPACITOR(V1)
-- -----------------------------------------------------------
--
-- Source:
-- rc.vhd
-- -----------------------------------------------------------


library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use WORK.all;

entity RC is
    generic  (RES : REAL := 1.0;  -- value of the resistor [Ohm], MIN: >0.0
              CAP : REAL := 1.0   -- value of the capacitor [F], MIN: >0.0
              );
    port     (terminal T1 : ELECTRICAL; -- connected to resistor
              terminal T2 : ELECTRICAL; -- common node of resistor and capacitor
              terminal T3 : ELECTRICAL  -- connected to capacitor
              );
begin
    assert (RES > 0.0) and (CAP > 0.0)
      report "ERROR: RES and CAP must be > 0.0"
      severity ERROR;
end entity RC;


architecture V1 of RC is 
begin
   
R1: entity RESISTOR(V1)  generic map (RES) port map (T1, T2);
C1: entity CAPACITOR(V1) generic map (CAP) port map (T2, T3);
   
end architecture V1;	
   
