-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Resistor
-- 
-- Description:
-- P1 and P2 are the two element terminals. VALUE_R is the resistance
-- in Ohms. The value may be positive, negative, and zero.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- resistor.vhd
-- -----------------------------------------------------------

   
library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity RESISTOR is
    generic (VALUE_R      : REAL := 1.0   -- resistance [Ohm]
            );
    port    (terminal P1  : ELECTRICAL;   -- electrical terminal
             terminal P2  : ELECTRICAL    -- electrical terminal
            );
end entity RESISTOR;


architecture V1 of RESISTOR is
    quantity V across I through P1 to P2;
begin
    V == VALUE_R * I;
end architecture V1;

