-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Independent Voltage Step Source
-- 
-- Description:
-- P and N are the positive and negative element terminals. 
-- The initial voltage value is 0. The voltage is 0 until T_DELAY.
-- The value after time T_DLEAY + T_RISE is AMPL. 
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- step.vhd
-- -----------------------------------------------------------


library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
      
entity STEP is
    generic (AMPL     : REAL := 1.0;     -- magnitude [V]
             T_DELAY  : TIME := 1 ms;    -- delay [TIME]
	     T_RISE   : REAL := 1.0      -- rise time [s], MIN: >=0.0
            );
    port    (terminal P  : ELECTRICAL;  -- positive terminal
             terminal N  : ELECTRICAL   -- negative terminal
            );
end entity STEP;   

architecture V1 of STEP is
    quantity V across I through P to N;
    signal S_OUT : REAL := 0.0;
begin
    S_OUT <= AMPL after T_DELAY when DOMAIN = TIME_DOMAIN;
    V == S_OUT'RAMP(T_RISE);
end architecture V1;
