-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Linear Voltage-Controlled Voltage Source with RI and ROUT
-- 
-- Description:
-- IN1 and IN2 are the positive and negative controlling terminals,
-- respectively. The input voltage controls the output voltage.
-- V is the voltage gain. RI is the input resistor between IN1 and
-- IN2. ROUT is the outout resitor.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- vcvs_r.vhd
-- -----------------------------------------------------------


library IEEE_proposed;
   use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity VCVS_R is
   generic (V    : REAL :=  1.0;   -- voltage gain
            RIN  : REAL := 50.0;   -- input resistor [Ohm]
            ROUT : REAL := 50.0    -- output resistor [Ohm]    
           );
   port    (terminal IN1  : ELECTRICAL;  -- controlling plus terminal
            terminal IN2  : ELECTRICAL;  -- controlling minus terminal
            terminal OUTP : ELECTRICAL   -- output plus terminal
           );
end entity VCVS_R;

architecture V1 of VCVS_R is
   quantity VIN  across IIN  through IN1 to IN2;   -- input branch
   quantity VOUT across IOUT through OUTP;         -- output branch
   quantity VCTRL : REAL;         -- free quantity
begin
   VIN   == RIN*IIN;
   VCTRL == V*VIN;                -- description of functionality
   VOUT  == VCTRL + ROUT*IOUT;
end architecture v1;
