-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Testbench for Voltage Sources
-- 
-- Description:
-- The value of a sinusoidal voltage at N_SINE is gained by a voltage
-- controlled voltage source. This value at node N1times2 is gained
-- by a voltage controlled voltage source that considers input
-- and output resistors. The output node N_OUT is connected with
-- the electrical reference node by a resistor of 50 Ohm. The
-- simulation should run until 40 ms.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed          ELECTRICAL_SYSTEMS
-- WORK                   SINE(V1)
-- WORK                   VCVS(V1)
-- WORK                   VCVS_R(V1)
-- -----------------------------------------------------------
--
-- Source:
-- section6.3.3_sources/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_SOURCES of BENCH is
    terminal N1_SINE, N1times2, N_OUT : ELECTRICAL;
begin

D1:  entity SINE(V1) generic map (A => 2.0, FREQ => 50.0)
     port map    (N1_SINE, ELECTRICAL_REF);
   
D2:  entity VCVS(V1) generic map (V => 2.0)
     port map    (N1_SINE, ELECTRICAL_REF, N1times2);

D3:  entity VCVS_R(V1) generic map (V => 4.0)
     port map    (N1times2, ELECTRICAL_REF, N_OUT);

     -- VCTRL of VCVS_R(V1) equals 4.0*N1times2-voltage
     -- 
     -- =>  voltage at N_OUT equals 2.0*N1times2-voltage 
     -- ROUT=50.0 of VCVS_R(V1), R_LOAD=50.0
   
R_LOAD:  entity RESISTOR(V1) generic map (50.0)
     port map    (N_OUT, ELECTRICAL_REF);
   
end architecture BENCH_SOURCES;   
