-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Delay Block
-- 
-- Description:
-- The input voltage is delayed by time T_DELAY. The model realizes
-- a voltage-controlled voltage source.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- delay_block.vhd
-- -----------------------------------------------------------

library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
   
entity DELAY_BLOCK is
    generic (T_DELAY : REAL  -- delay time [s], MIN: 0.0
            );
    port (terminal INP  : ELECTRICAL;  -- controlling terminal
          terminal OUTP : ELECTRICAL   -- output terminal
         );
begin
    assert T_DELAY >= 0.0
      report "T_DELAY must be >= 0.0"
      severity ERROR;
end entity DELAY_BLOCK;
   
architecture IDEAL of DELAY_BLOCK is
    quantity VIN  across              INP;
    quantity VOUT across IOUT through OUTP;
begin
    VOUT == VIN'DELAYED(T_DELAY);
end architecture IDEAL;
