-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Integrator Block
-- 
-- Description:
-- The ouput voltage is the integral of the input voltage. The
-- model is realized by a voltage-controlled voltage source.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- integrator.vhd
-- -----------------------------------------------------------

library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity INTEGRAL_BLOCK is
  generic (GAIN  : REAL := 1.0;  -- gain 
           IC    : REAL := 0.0   -- initial value [V]
          );
  port (terminal INP  : ELECTRICAL; -- controlling terminal
        terminal OUTP : ELECTRICAL  -- output terminal
       );
end entity INTEGRAL_BLOCK;
     
architecture IDEAL of INTEGRAL_BLOCK is
  quantity VIN  across INP;               -- open input branch
  quantity VOUT across IOUT through OUTP; -- voltage source
begin
  if DOMAIN = QUIESCENT_DOMAIN use
     VOUT == IC;                   -- during DC analysis
  else
     VOUT == GAIN*VIN'INTEG + IC;  -- in transient analysis
  end use;
end architecture IDEAL;   
