-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for Peak Detector
-- 
-- Description:
-- The voltage at node N2 follows the positive peaks of the
-- voltage at node N1. The simulation should run until 1 ms. 
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- WORK                    PEAKDETECTOR(IDEAL)
-- -----------------------------------------------------------
--
-- Source:
-- section6.3.5_peakdetector/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use IEEE.MATH_REAL.all, WORK.all;
   
entity BENCH is end entity BENCH;

architecture BENCH_PEAKDETECTOR of BENCH is
    terminal N1, N2     : ELECTRICAL;
    quantity VIN across IIN through N1;
    constant AMP  : REAL := 1.0;
    constant A    : REAL := 1.0e3;
    constant FREQ : REAL := 1.0e3;
begin
    VIN == AMP*EXP(A*NOW)*SIN(MATH_2_PI*FREQ*NOW);

UUT: entity PEAKDETECTOR(IDEAL)
       port map (INP => N1, OUTP => N2);
end architecture BENCH_PEAKDETECTOR;

