-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Sample and Hold Block
-- 
-- Description:
-- The input voltage is sampled after time DELAY. The model
-- realizes a zero order sample and hold.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- sample_and_hold.vhd
-- -----------------------------------------------------------

library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
   
entity SAMPLE_AND_HOLD is
    generic (TSAMPLE  : REAL := 1.0E-3;  -- sampling time [s], MIN: >0.0
             DELAY    : REAL := 0.0      -- delay [s], MIN: 0.0 
            );
    port (terminal INP  : ELECTRICAL;    -- controlling terminal
          terminal OUTP : ELECTRICAL     -- output terminal
         );
end entity SAMPLE_AND_HOLD;
   
architecture IDEAL of SAMPLE_AND_HOLD is
    quantity VIN  across              INP;
    quantity VOUT across IOUT through OUTP;
begin
    VOUT == VIN'ZOH(TSAMPLE, DELAY);
end architecture IDEAL;

