-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for Sample and Hold Block
-- 
-- Description:
-- A 1 kHz sinusoidal voltage is sampled after 250 us with a period
-- of 50 us. The simulation should run until 1 ms. 
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- WORK                    SAMPLE_AND_HOLD(IDEAL) 
-- -----------------------------------------------------------
--
-- Source:
-- section6.3.5_sample_and_hold/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use IEEE.MATH_REAL.all;
    use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_SAMPLE_AND_HOLD of BENCH is 
    terminal N_IN, N_OUT : ELECTRICAL;
    quantity VIN across IIN through N_IN;
begin
    VIN == SIN(MATH_2_PI*1.0E3*NOW);

UUT: entity SAMPLE_AND_HOLD(IDEAL)
       generic map (TSAMPLE => 50.0E-6, DELAY => 250.0E-6)
       port map    (INP => N_IN, OUTP => N_OUT);

end architecture BENCH_SAMPLE_AND_HOLD;  
