-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for PID Controller
-- 
-- Description:
-- The input quantity of the PID controller is given by the 
-- QPWL source. The simulation should run until 10 s. 
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- WORK                    QPWL(BASIC)
-- WORK                    PID(IDEAL)
-- -----------------------------------------------------------
--
-- Source:
-- section6.4_pid/tb/bench.vhd
-- -----------------------------------------------------------

use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_PID of BENCH is
   quantity INPUT, OUTPUT : REAL;  -- connection points
begin
   Q1: entity QPWL(BASIC)
      generic map (WAVE => 
          (0.0, 0.0, 1.0, 1.0, 2.0, 1.0, 4.0, -1.0, 5.0, -1.0,
           6.0, 0.0, 10.0, 0.0))
      port map (INPUT);

UUT: entity PID(IDEAL)
      generic map (KR => 5.0, TN => 2.0, TV => 1.0)
      port map (Q_IN => INPUT, Q_OUT => OUTPUT);
end architecture BENCH_PID;
