-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Test-bench for D-to-A Converter
-- 
-- Description:
-- The signal S_IN is converted to voltages that can be measured
-- at node N_OUT. The simulation should run until 40 ns.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    STD_LOGIC_1164
-- WORK                    D2A(IDEAL)
-- -----------------------------------------------------------
--
-- Source:
-- section6.5.1_d2a/tb/bench.vhd
-- -----------------------------------------------------------


library IEEE, IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use IEEE.STD_LOGIC_1164.all;
    use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_D2A of BENCH is
   signal   S_IN    : STD_LOGIC;
   terminal N_OUT   : ELECTRICAL;  --
begin

   S_IN <= '0', 
           '1' after  5 ns, 
           '0' after 10 ns,
           '1' after 15 ns, 
           '0' after 20 ns,
           '1' after 25 ns, 
           '0' after 35 ns;

UUT: entity D2A(IDEAL)
        generic map (TD_01 => 1 ns,   TD_10 => 2 ns,
                     TRISE => 2.0E-9, TFALL => 2.0E-9)
        port map (S_IN, N_OUT);

end architecture BENCH_D2A;
