-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Mixer test bench
-- 
-- Description:
-- The test-bench shows how a two-tone sine wave signal
-- is mixed and thereby downconverted using a second
-- single-tone sine wave.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    P_SIN(SINGLE_TONE)
-- WORK                    MIXER(RF)
-- WORK                    SINK(A1)
-- -----------------------------------------------------------
--
-- Source:
-- section7.3.2_mixer/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;

entity BENCH is end BENCH;


architecture TEST_MIX of BENCH is

  --constants
  constant  FIRST_TONE :  REAL:= -30.0;
  constant  FIRST_FREQ :  REAL:= 1.0e03;
  constant  SECND_TONE :  REAL:= -40.0;
  constant  SECND_FREQ :  REAL:= 1.1e03;
  constant  LO_TONE    :  REAL:= -30.0;
  constant  LO_FREQ    :  REAL:= 1.0e03;
  constant  R_s        :  REAL:=  50.0;        -- Ohm     
  constant  POWER_GAIN :  REAL:=   0.0;
  constant  COMP_POINT :  REAL:= -20.0;
  constant  IIP3_POINT :  REAL:= -30.0;
  constant  NOISE_FIG  :  REAL:=   2.5;

  terminal N_1, N_2, N_CLK, N_CTRL, N_VDD: ELECTRICAL;
  --branch quantities
  quantity V_R2  across I_R2  through N_2;  
  quantity V_VDD across I_VDD through N_VDD;

begin                                          
                  
  V_VDD == 2.7;
  
  V_R2 == R_S * I_R2;         
               
  SRC: entity P_SIN(TWO_TONE)
    generic map ( PA_DBM  => FIRST_TONE,
                  FREQ    => FIRST_FREQ,
		  PA2_DBM => SECND_TONE,
		  FREQ2   => SECND_FREQ)   
    port map (P=>N_1, M=>ELECTRICAL_REF);
                         
  LO: entity P_SIN(SINGLE_TONE)
    generic map ( PA_DBM => LO_TONE,
                  FREQ   => LO_FREQ,
		  PHASE  => 0.0)   
    port map (P=>N_CLK, M=>ELECTRICAL_REF);
                         
  MIX: entity MIXER(RF)
    generic map ( GP_DB => POWER_GAIN,                           
		  iP3_DBM => IIP3_POINT,
		  FNOISE_DB => NOISE_FIG    
		  )
    port map (P_IN=>N_1,
	      P_OUT=>N_2,
	      P_CLOCK=>N_CLK,
	      VDD=>N_VDD,
	      GND=>ELECTRICAL_REF);
                         
  SNK: entity SINK(A1)
    port map (P_IN=>N_1,
	      P_OUT=>N_2,
	      GND=>ELECTRICAL_REF);
                         
end architecture TEST_MIX;
                                                                                      
--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


