-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Charge pump
-- 
-- Description:
-- This models describes a simple charge pump which contains
-- switchable resistances driven by a current source.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- cp.vhd
-- -----------------------------------------------------------

library IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity CP is 
  generic (R_ISRC     : REAL := 1.0e3;  -- current sources resistance [Ohm]
           ROUT       : REAL := 50.0    -- output resistance [Ohm]
	   );
  port (terminal P_OUT: ELECTRICAL;  -- output pin
	terminal VDD  : ELECTRICAL;  -- positive voltage
	terminal VSS  : ELECTRICAL;  -- negative voltage
	signal S_UP   : BIT;         -- up signal
	signal S_DOWN : BIT          -- down signal
	);    
end entity CP;   

architecture SIMPLE of CP is
  constant RON   : REAL:=1.0;
  constant ROFF  : REAL:=1.0E9;
  terminal N_up  : ELECTRICAL;
  terminal N_down: ELECTRICAL;
  terminal N_int : ELECTRICAL;
  signal   R_SWUP: REAL:=1.0E9;
  signal   R_SWDN: REAL:=1.0E9;
  quantity V_SWUP across I_SWUP through N_UP  to N_INT;
  quantity V_SWDN across I_SWDN through N_INT to N_DOWN;
  quantity V_ROUT across I_ROUT through P_OUT to N_INT;
  quantity V_RUP  across I_RUP  through VDD   to N_UP;
  quantity V_RDN  across I_RDN  through VSS   to N_DOWN;
  quantity V_R1   across I_R1   through N_INT to ELECTRICAL_REF;

begin
  
  R_SWUP <= RON when S_UP='1' else ROFF;
  R_SWDN <= RON when S_DOWN='1' else ROFF;
  V_SWUP == R_SWUP * I_SWUP;
  V_SWDN == R_SWDN * I_SWDN;
  V_RUP  == R_ISRC * I_RUP;
  V_RDN  == R_ISRC * I_RDN;
  V_ROUT == ROUT * I_ROUT;
  V_R1 == 1.0E6 * I_R1;

end architecture SIMPLE;                                            

--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


