-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     VCO test bench
-- 
-- Description:
-- This model shows how the frequency changes if an analog 
-- VCO is controlled by a piecewise linear signal.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    VCO(ANALOG)
-- -----------------------------------------------------------
--
-- Source:
-- section7.3.4_vco/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;


entity BENCH is end BENCH;


architecture TEST_VCO of BENCH is
  constant  LO_TONE    :  REAL:= -30.0;
  constant  LO_FREQ    :  REAL:= 1.0e03;
  constant  LO_KF      :  REAL:= 1.0e05;
  constant  R_S        :  REAL:=  50.0;        -- Ohm     

  terminal N_CLK, N_CTRL, N_VDD: ELECTRICAL;
  --branch quantities
  quantity V_R2  across I_R2  through N_CLK;  
  quantity V_VDD across I_VDD through N_VDD;
  quantity V_VCTRL across I_VCTRL through N_CTRL;

  signal CTRL: REAL:=0.0;
begin                                          
                  
  V_VDD == 2.7;
  CTRL<=0.0, -5.0E-3 after 10.2MS;
  V_VCTRL == CTRL;
  
  V_R2 == R_S * I_R2;         
               
  LO: entity VCO(ANALOG)
    generic map ( AMPL_DBM => LO_TONE,
                 FREQ_0 => LO_FREQ,
		 K_FREQ => LO_KF)
    port map (P_CTRL=>N_CTRL,
	      P_OUT=>N_CLK,
	      VDD=>N_VDD,
	      GND=>ELECTRICAL_REF);
                         
end architecture TEST_VCO;
                                                                                      

