-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     D2A test bench
-- 
-- Description:
-- The test-bench shows how a digital signal from the pseudorandom
-- binary source is converted to the analog domain. 
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    PRBS(SHIFT_REGISTER)
-- WORK                    D2A(BHV_RF)
-- -----------------------------------------------------------
--
-- Source:
-- section7.3.8_dac/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;

entity BENCH is end BENCH;

architecture TEST_D2A of BENCH is

  constant  IN_TONE    :  REAL:= -30.0;
  constant  IN_FREQ    :  REAL:= 5.0E06;
  constant  GRADE      :  INTEGER:= 6;
  constant  R_S        :  REAL:=  50.0;

  terminal N_A: ELECTRICAL;

  quantity V_R2  across I_R2  through N_A;  

  signal S_BIT: BIT_VECTOR(0 to 0);

begin                                          
                  
  SRC3: entity PRBS(SHIFT_REGISTER)
          generic map (POLYGRAD => GRADE,
		       BIT_TIME => 1.0/IN_FREQ*1SEC)
          port map (BIT_OUT => S_BIT(0));

  CONV: entity D2A(BHV_RF)
    generic map(PMAX_DBM => IN_TONE)
    port map (D => S_BIT,
	      A => N_A,
	      GND => ELECTRICAL_REF);
  
  V_R2 == R_S * I_R2;

end architecture TEST_D2A;
