-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Frequency measurement unit
-- 
-- Description:
-- The test-bench shows how the current frequency of the input
-- signal can be measured by a mixed-signal model. The distance
-- in time between two successive crossings of a given threshold
-- is measured.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- -----------------------------------------------------------
--
-- Source:
-- freq.vhd
-- -----------------------------------------------------------

library IEEE,IEEE_proposed;
  use IEEE.MATH_REAL.all;
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity FREQ is 
  generic (THRESHOLD : real := 0.0     -- threshold value for period measurement [V]
	   );
  port (terminal P_1: ELECTRICAL;   -- terminal at pin 1
	terminal P_2: ELECTRICAL;   -- terminal at pin 2
	quantity F_HZ: out REAL     -- output frequency
	);
end entity FREQ;   

architecture MIXED_SIGNAL of FREQ is
                                       
  quantity V_12 across   P_1 to P_2;
  signal S_FREQ:  REAL := 0.0;
  signal T_OLD:   REAL := 0.0;
  signal S_12 :   BOOLEAN:= FALSE;

begin

  -- a-to-d conversion
  S_12 <= V_12'ABOVE(THRESHOLD);

  -- digital process
  process (S_12) is
    begin
      if S_12 then
        T_OLD<=NOW;
        if NOW>T_OLD and T_OLD>0.0 then
          S_FREQ<=1.0/(NOW-T_OLD);
        else
	  S_FREQ<=0.0;
        end if;
      end if;
  end process;

  -- d-to-a conversion
  F_HZ == S_FREQ;    
  break on S_FREQ;

end architecture MIXED_SIGNAL;

