-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Frequency measurement unit test bench
-- 
-- Description:
-- The test-bench shows the frequency measurement of a voltage
-- controlled oscillator output signal.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    FREQ(MIXED_SIGNAL)
-- WORK                    VCO(ANALOG)
-- -----------------------------------------------------------
--
-- Source:
-- section7.4.2_freq/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;


entity BENCH is end BENCH;


architecture TEST_FREQ of BENCH is

  --constants
  constant  LO_TONE    :  REAL:= -30.0;
  constant  LO_FREQ    :  REAL:= 1.5E03;
  constant  LO_KF      :  REAL:= 1.0E05;
  constant  R_S        :  REAL:=  50.0;        -- Ohm     

  terminal N_CLK, N_CTRL, N_VDD: ELECTRICAL;
  --branch quantities
  quantity V_R2  across I_R2  through N_CLK;  
  quantity V_VDD across I_VDD through N_VDD;
  quantity V_VCTRL across I_VCTRL through N_CTRL;

  quantity FREQUENCY: REAL;
  
begin                                          
                  
  V_VDD == 2.7;

  V_VCTRL == 5.0E-3 * SIN(400.0*NOW);

  V_R2 == R_S * I_R2;         
               
  LO: entity VCO(ANALOG)
    generic map ( AMPL_DBM => LO_TONE,
                 FREQ_0 => LO_FREQ,
		 K_FREQ => LO_KF)
    port map (P_CTRL=>N_CTRL, P_OUT=>N_CLK, VDD=>N_VDD,
	      GND=>ELECTRICAL_REF);

  ME: entity FREQ(MIXED_SIGNAL)
    port map (P_1 => N_CLK, P_2 => ELECTRICAL_REF,
	      F_HZ => FREQUENCY);
end architecture TEST_FREQ;
