-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Power meter test bench
-- 
-- Description:
-- The test-bench shows the power measurement of a compressed
-- signal before and after a low-noise amplifier. The architecture
-- feedthrough is used before and the architecture terminating
-- is used after the LNA.
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- IEEE                    MATH_REAL
-- WORK                    P_SIN(SINGLE_TONE)
-- WORK                    LNA(RF)
-- WORK                    POWER_METER(FEEDTHROUGH)
-- WORK                    POWER_METER(TERMINATING)
-- -----------------------------------------------------------
--
-- Source:
-- section7.4.3_power/tb/bench.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
  use IEEE.MATH_REAL.all;
  use WORK.all;

entity BENCH is end BENCH;

architecture TEST_PM of BENCH is

  --constants
  constant  FIRST_TONE :  REAL:= -40.0;
  constant  FIRST_FREQ :  REAL:= 1.0E03;
  constant  POWER_GAIN :  REAL:=   6.0;
  constant  IIP3_POINT :  REAL:= -23.0;

  --terminals
  terminal N_INT: ELECTRICAL;
  terminal N_1, N_10, N_2, N_VDD: ELECTRICAL;

  --branch quantities
  quantity V_VDD across I_VDD through N_VDD;
  quantity P_IN, P_OUT: REAL;

begin                                          
                  
  V_VDD == 2.7;

  SRC1: entity P_SIN(AM)
    generic map ( PA_DBM => FIRST_TONE,
                  FREQ   => FIRST_FREQ,
		  FREQM  => FIRST_FREQ/1000.0,
		  MDI    => 10.0)   
    port map (P=>N_1, M=>ELECTRICAL_REF);

  LNA1: entity LNA(RF)
    generic map ( GP_DB   => POWER_GAIN,                           
		  IP3_DBM => IIP3_POINT )
    port map (P_IN=>N_10, P_OUT=>N_2, VDD=>N_VDD,
	      GND=>ELECTRICAL_REF);
                         
  PWRin: entity POWER_METER(FEEDTHROUGH)
    generic map ( T_INTEG => 1.0/FIRST_FREQ )
    PORT MAP (P_1=>N_1, P_2=>N_10, P_DBM=>P_IN);
  
  PWRout: entity POWER_METER(TERMINATING)
    generic map ( T_INTEG => 1.0/FIRST_FREQ )
    PORT MAP (P_1=>N_2, P_2=>ELECTRICAL_REF, P_DBM=>P_OUT);
  
end architecture TEST_PM;


