-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:     Lowpass filter
-- 
-- Description:
-- This part describes the filter package with functions for
-- computation of lowpass filter coefficients
--
-- Literature:
-- 
--
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE                    MATH_REAL
-- -----------------------------------------------------------
--
-- Source:
-- filter_functions_header.vhd
-- -----------------------------------------------------------

library IEEE;
  use IEEE.MATH_REAL.all;

package FILTER is

  -- -------------------------------------------------------------------------
  -- Coefficients for normalized lowpass filter
  -- 
  -- LP(s) = 1.0 / (1 + a*S + b*S^2)
  -- -------------------------------------------------------------------------

  function LOWPASS_BUTTERWORTH_A 
           (GRAD : INTEGER)    -- grade of filter
  return REAL_VECTOR;          -- array with filter coefficients 

  function LOWPASS_BUTTERWORTH_B 
           (GRAD : INTEGER)    -- grade of filter
  return REAL_VECTOR;          -- array with filter coefficients

end package FILTER;



       

