-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Phase shifter
-- 
-- Description:
-- This model describes an ideal PI/4 phase shifter. The frequency
-- of the input signal has to be provided as a parameter to the
-- model.
--
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- phase_shifter.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity SHIFTER is
    generic (RIN  : REAL := 50.0;
             ROUT : REAL := 50.0;
             FREQ : REAL := 1.0);
    port    (terminal INP    : ELECTRICAL;  -- input
             terminal OUT0   : ELECTRICAL;  -- 0 delay   (cos)
             terminal OUT90  : ELECTRICAL); -- 90 delay  (sin)
end entity SHIFTER;


architecture IDEAL of SHIFTER is

    constant DELAY : REAL := 1.0/FREQ/4.0;
    
    quantity VIN    across IIN    through INP;
    quantity VOUT0  across IOUT0  through OUT0;
    quantity VOUT90 across IOUT90 through OUT90;
  
begin

    VIN    == RIN*IIN;
    VOUT0  == 2.0*VIN + ROUT*IOUT0;
    VOUT90 == 2.0*VIN'DELAYED(DELAY) + ROUT*IOUT90;
     
end architecture IDEAL;
