-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Splitter
-- 
-- Description:
-- This model describes an ideal splitter block which splits one
-- input signal into two output signals without loosing any
-- signal power. In real splitter blocks the signal would
-- suffer loss due to mismatch.
--
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- splitter.vhd
-- -----------------------------------------------------------

library IEEE, IEEE_proposed;                                            
  use IEEE_proposed.ELECTRICAL_SYSTEMS.all;

entity SPLITTER IS 
  generic (RIN     : REAL := 50.0;
	   ROUT    : REAL := 50.0);
  port (TERMINAL P_I,  P_O1, P_O2, GND: ELECTRICAL);    
end entity SPLITTER;   

architecture IDEAL of SPLITTER is

  --terminals
  terminal N_O1, N_O2: ELECTRICAL;

  --branch quantities
  quantity V_RI   across I_RI   through P_I  to GND;
  quantity V_RO1  across I_RO1  through N_O1 to P_O1;
  quantity V_RO2  across I_RO2  through N_O2 to P_O2;
  quantity V_SRC1 across I_SRC1 through N_O1 to GND;
  quantity V_SRC2 across I_SRC2 through N_O2 to GND;

begin

-- input port resistance
  V_RI == RIN * I_RI;
  
-- signal sources
  V_SRC1 == 2.0*V_RI;
  V_SRC2 == 2.0*V_RI;
  
-- output port resistances
  V_RO1 == ROUT * I_RO1;
  V_RO2 == ROUT * I_RO2;

end architecture IDEAL;                                            

