-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Inertial and Transport Delay
-- 
-- Description:
-- The test-bench shows how inertial and transport delay of
-- digital signals work in VHDL. The simulation should run
-- unit 20 ns
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- 
-- -----------------------------------------------------------
--
-- Source:
-- section6.2.3_delay_mechanisms/tb/bench.vhd
-- -----------------------------------------------------------

entity BENCH is end entity BENCH;

architecture BENCH_DELAY of BENCH is   
  signal A, B            : BIT;
  signal C_INERTIAL_1_ns : BIT;
  signal C_INERTIAL_2_ns : BIT;
  signal C_TRANSPORT     : BIT;
begin
   
  A <= '0', '1' after 10 ns, '0' after 11 ns;
  B <= '0', '1' after  2 ns, '0' after  5 ns, '1' after 15 ns;

  C_INERTIAL_1_ns <=           a or b after 1 ns;
  C_INERTIAL_2_ns <=           a or b after 2 ns;
  C_TRANSPORT     <= transport a or b after 2 ns;
end architecture BENCH_DELAY;
