-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:       Simple Digital Divider
-- 
-- Description:
-- The BIT-value signal CLK changes its value after 1 ms. This
-- signal is divided by the model DIVIDER(SIMPLE) using N=5. 
-- In an intervall of 10 ms there occur 5 pulses of CLK and one
-- pulse of the dividers output OUTP. The simulation should
-- run until 50 ms.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- WORK                    DIVIDER(SIMPLE)
-- -----------------------------------------------------------
--
-- Source:
-- section6.2.4_divider/tb/bench.vhd
-- -----------------------------------------------------------

use WORK.all;  -- makes DIVIDER(SIMPLE) available

entity BENCH is end entity BENCH;
  
architecture BENCH_SIMPLE of BENCH is
  signal CLK, OUTP : BIT;
begin
  CLK <= not CLK after 1 ms; 
  
UUT: entity DIVIDER(SIMPLE)
       generic map (5)          -- positional association
       port map    (CLK, OUTP);
       
end architecture BENCH_SIMPLE;   
   
