-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      RC Chain
-- 
-- Description:
-- The test-bench consists of a chain of two simple RC circuits
-- connected to a step voltage source. ELECTRICAL_REF is the
-- electrical reference node that is declared in the nature
-- ELECTRICAL in the package ELECTRICAL_SYSTEMS of the library
-- IEEE_proposed. The simulation should run until 10 ms.
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- WORK                    STEP(V1)
-- WORK                    RC(V1)
-- -----------------------------------------------------------
--
-- Source:
-- section6.3.2_rc_circuit/tb/bench.vhd
-- -----------------------------------------------------------


library IEEE_proposed;
    use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
    use WORK.all;

entity BENCH is end entity BENCH;

architecture BENCH_RC of BENCH is
    terminal A, B, C : ELECTRICAL;
begin

VS1: entity STEP(V1) generic map (T_RISE => 2.0E-3)
     port map    (A, ELECTRICAL_REF);
   
RC1: entity RC(V1) generic map (4.0E2, 1.0E-6)
     port map    (A, B, ELECTRICAL_REF);
   
RC2: entity RC(V1) generic map (1.0E3, 1.0E-6)
     port map    (B, C, ELECTRICAL_REF);
   
end architecture BENCH_RC;   
