-- -----------------------------------------------------------
-- 
-- Additional material to the book
-- Modeling and Simulation for RF System Design
-- 
--
-- THIS MODEL IS LICENSED TO YOU "AS IT IS" AND WITH NO WARRANTIES, 
-- EXPRESSED OR IMPLIED. THE AUTHORS SPECIFICALLY DISCLAIM ALL IMPLIED 
-- WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- THEY MUST NOT HAVE ANY RESPONSIBILITY FOR ANY DAMAGES, FINANCIAL OR
-- LEGAL CLAIMS WHATEVER.
-- -----------------------------------------------------------

-- Name:      Independent Sinusoidal Voltage Source
-- 
-- Description:
-- P and N are the positive and negative terminals, respectively.
-- The value of the voltage source is equal to V0+A*SIN(2*pi*FREQ*t).
-- 
-- Literature:
-- 
-- Dependencies: 
-- -----------------------------------------------------------
-- Logical Library         Design unit
-- -----------------------------------------------------------
-- IEEE_proposed           ELECTRICAL_SYSTEMS
-- -----------------------------------------------------------
--
-- Source:
-- sine.vhd
-- -----------------------------------------------------------


library IEEE, IEEE_proposed;
   use IEEE_proposed.ELECTRICAL_SYSTEMS.all;
   use IEEE.MATH_REAL.all;       -- for access to SIN and MATH_2_PI


entity SINE is
    generic (V0   : REAL := 0.0;  -- offset voltage [V] 
             A    : REAL := 1.0;  -- amplitude [V]
             FREQ : REAL := 50.0  -- frequency [Hz], MIN: 0.0
            );
    port (terminal P   : ELECTRICAL; -- positive terminal
          terminal N   : ELECTRICAL  -- negative terminal
          );
end entity SINE;

architecture V1 of SINE is
    quantity V across I through P to N;
begin
    V == V0 + A*SIN(MATH_2_PI*FREQ*NOW);
end architecture V1;

